#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliTestMode

configIfRangeMode = CliTestMode.Mode( name='config-if-range',
                                      prompt='\(config-if-[^\)]*\)#',
                                      parent=CliTestMode.configMode,
                                      cmdFromParent=
                                      'interface range create %s',
                                      testParams=[ 'test11-19', 'test41-49' ],
                                      rangeLen=9,
                                      cleanupCmd='default interface range %s' )
# The range has to not overlap any interfaces that have been used
# for normal interface configuration, due to the time bomb comments
# left behind by CliModeTests.py
