#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This file is created so that we could use the CliSession's OnCommitHandler
# with ConfigMount import, since we cannot do that directly in CliSession.py
# due to dependency reasons.

import CliSession, ConfigMount
import Tracing
import os

t0 = Tracing.trace0

disableCommitHandler = True if os.environ.get( 'CONFIG_SESSION_HANDLER' ) \
      == '0' else False

# Disable config mounts when calling commit handlers, as the session
# is already completed but we are still considered in the session.
@ConfigMount.withNoConfigMounts
def invokeSessionOnCommitHandlers( mode, sessionName ):
   """ Invokes the handlers for the current session.
       Returns True if there are no handler errors (or if commit handler disabled),
               False otherwise. """
   if disableCommitHandler:
      return True
   handlers = CliSession.sessionOnCommitHandlers.get( sessionName )
   handlerSuccess = True
   if handlers:
      for name in handlers.orderList:
         t0( "invoking handler for", name )
         handlerResponse = handlers.handlerMap[ name ]( mode, onSessionCommit=True )
         if handlerResponse:
            handlerSuccess = False
   return handlerSuccess
