#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import IpLibConsts
import Management


class XmppConfigMode( Management.MgmtConfigMode ):

   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, "xmpp" )


CliSave.GlobalConfigMode.addChildMode( XmppConfigMode )
XmppConfigMode.addCommandSequence( "Mgmt.xmpp" )


@CliSave.saver( "Mgmt::Xmpp::Config", "mgmt/xmpp/config" )
def saveXmpp( xmppConfig, root, sysdbRoot, options ):
   mode = root[ XmppConfigMode ].getSingletonInstance()
   cmds = mode[ "Mgmt.xmpp" ]

   if xmppConfig.enabled:
      cmds.addCommand( "no shutdown" )
   elif options.saveAll:
      cmds.addCommand( "shutdown" )

   if xmppConfig.starttlsPermitUnencrypted:
      cmds.addCommand( "connection unencrypted permit" )
   elif options.saveAll:
      cmds.addCommand( "no connection unencrypted permit" )

   if xmppConfig.ipAddrOrHostname:
      cmd = "server %s" % ( xmppConfig.ipAddrOrHostname, )
      if options.saveAll or xmppConfig.port != xmppConfig.defaultPort:
         cmd += " port %s" % ( xmppConfig.port, )
      cmds.addCommand( cmd )

   if options.saveAll or xmppConfig.vrfName != IpLibConsts.DEFAULT_VRF:
      cmds.addCommand( "vrf " + xmppConfig.vrfName )

   if xmppConfig.username:
      passwd = CliSave.sanitizedOutput( options, xmppConfig.password )
      cmds.addCommand( "username %s password 7 %s" % ( xmppConfig.username,
                                                       passwd ) )

   if options.saveAll or ( xmppConfig.initialPrivLevel !=
                           xmppConfig.defaultInitialPrivLevel ):
      cmds.addCommand( "session privilege %s" % ( xmppConfig.initialPrivLevel, ) )

   if xmppConfig.group:
      for group in xmppConfig.group.itervalues():
         cmd = "switch-group %s" % ( group.name, )
         if group.password:
            grpPasswd = CliSave.sanitizedOutput( options, group.password )
            cmd += " password 7 %s" % ( grpPasswd, )
         cmds.addCommand( cmd )

   if xmppConfig.domainName:
      cmds.addCommand( "domain %s" % ( xmppConfig.domainName, ) )
   if xmppConfig.srcIntfName:
      cmds.addCommand( "source-interface %s" % ( xmppConfig.srcIntfName, ) )
   elif options.saveAll:
      cmds.addCommand( "no source-interface" )

   if options.saveAll or xmppConfig.dscpValue != xmppConfig.dscpValueDefault:
      cmds.addCommand( "qos dscp %s" % xmppConfig.dscpValue )

