#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from RouterGeneralCliSave import getRouterGeneralVrfModeCtx

@CliSave.saver( 'Routing::VrfLeak::Config', 'routing/vrfleak/config' )
def saveVrfLeakConfig( entity, root, sysdbRoot, options ):
   for vrfName, vrf in entity.vrf.iteritems():
      assert vrf
      mode = getRouterGeneralVrfModeCtx( root, vrfName )
      cmds = mode[ 'vrfConfig' ]

      for sourceVrf, vlc in vrf.leakFrom.iteritems():
         assert vlc
         cmds.addCommand( "leak routes source-vrf %s subscribe-policy %s" %
                          ( sourceVrf, vlc.routeMap ) )
