#!/usr/bin/env python
# Copyright (c) 2009, 2010, 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from ReversibleSecretCli import encodeKey
from IntfCliSave import IntfConfigMode
from CliMode.VmTracer import VCenterMode
from CliMode.VmTracer import VShieldMode
from IpLibConsts import DEFAULT_VRF

class VShieldConfigMode( VShieldMode, CliSave.Mode ):
   def __init__( self, param ):
      VShieldMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

VShieldConfigMode.addCommandSequence( 'VmTracer.vShield' )

class VCenterConfigMode( VCenterMode, CliSave.Mode ):
   def __init__( self, param ):
      VCenterMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( VCenterConfigMode, 
                                       after=[ IntfConfigMode ] )
VCenterConfigMode.addCommandSequence( 'VmTracer.vCenter' )
VCenterConfigMode.addChildMode( VShieldConfigMode,
                                after=[ 'VmTracer.vCenter' ] )

@CliSave.saver( 'VmwareVI::ViConfig', 'vmtracer/config/session', 
                requireMounts = ( 'mgmt/security/config', ) )
def saveVmTracerViConfig( entity, root, sysdbRoot, options, requireMounts ):
   sessionDir = entity.parent
   sessionName = sessionDir.name
   mode = root[ VCenterConfigMode ].getOrCreateModeInstance( sessionName )
   cmdSeq = mode[ 'VmTracer.vCenter' ]
   if entity.url:
      cmdSeq.addCommand( 'url %s' %( entity.url ) )
   if entity.username != '':
      cmdSeq.addCommand( 'username %s' %
            CliSave.sanitizedOutput( options, entity.username ) )
   if entity.password != '':
      securityConfig = requireMounts[ 'mgmt/security/config' ]
      myKey = None if securityConfig.commonKeyEnabled else 'VmwareVds'
      encryptedPasswd = encodeKey( entity.password, key=myKey, algorithm='MD5' )
      cmdSeq.addCommand( 'password 7 %s' %
            CliSave.sanitizedOutput( options, encryptedPasswd ) )
   if not entity.autoVlan:
      cmdSeq.addCommand( 'autovlan disable' )
   if entity.allowedVlans != "1-4094":
      if not entity.allowedVlans:
         cmdSeq.addCommand( 'no allowed-vlan' )
      else:
         cmdSeq.addCommand( 'allowed-vlan %s' % ( entity.allowedVlans ) )
   if entity.vrf != DEFAULT_VRF:
      cmdSeq.addCommand( 'vrf %s' % ( entity.vrf ) )
   if entity.sourceIntf != '':
      if not entity.sourceIntf:
         cmdSeq.addCommand( 'no source-interface' )
      else:
         cmdSeq.addCommand( 'source-interface %s' % ( entity.sourceIntf ) )

@CliSave.saver( 'VmwareVI::VsConfig', 'vmtracer/config/session',
                requireMounts = ( 'mgmt/security/config', ) )
def saveVmTracerVsConfig( entity, root, sysdbRoot, options, requireMounts ):
   sessionDir = entity.parent
   sessionName = sessionDir.name
   mode = root[ VCenterConfigMode ].getOrCreateModeInstance( sessionName )
   mode = mode[ VShieldConfigMode ].getOrCreateModeInstance( 'vxlan' )
   cmdSeq = mode[ 'VmTracer.vShield' ]
   if entity.url:
      cmdSeq.addCommand( 'url %s' %( entity.url ) )
   if entity.username != '':
      cmdSeq.addCommand( 'username %s' %
            CliSave.sanitizedOutput( options, entity.username ) ) 
   if entity.password != '':
      securityConfig = requireMounts[ 'mgmt/security/config' ]
      myKey = None if securityConfig.commonKeyEnabled else 'VShield'
      encryptedPasswd = encodeKey( entity.password, key=myKey, algorithm='MD5' )
      cmdSeq.addCommand( 'password 7 %s' %
            CliSave.sanitizedOutput( options, encryptedPasswd ) )
