#!/usr/bin/env python
# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, IntfCliSave
IntfCliSave.IntfConfigMode.addCommandSequence( 'VmTracer.config' )

@CliSave.saver( 'Cdp::CdpConfig', 'l2discovery/cdp/config' )
def saveVmTracerIntfConfig( entity, root, sysdbRoot, options ):

   # Save interface specific settings
   for intfName in entity.intfNames:
      mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance( intfName )
      intfCmds = mode[ 'VmTracer.config' ]
      intfCmds.addCommand( 'vmtracer vmware-esx' )
   for lagName in entity.lagNames:
      mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance( lagName )
      intfCmds = mode[ 'VmTracer.config' ]
      intfCmds.addCommand( 'vmtracer vmware-esx' )
