# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements saving the Virtual Cable CLI, including port mux
# interfaces and interface-specific configuration.
#-------------------------------------------------------------------------------
import CliSave
from IntfCliSave import IntfConfigMode
from CliMode.VirtualCableMode import VirtualCableMode, VirtualCablePortMode

class VirtualCableCliSaveMode( VirtualCableMode, CliSave.Mode ):
   def __init__( self, param ):
      VirtualCableMode.__init__( self )
      CliSave.Mode.__init__( self, param )
      
   def __cmp__( self, other ):
      return cmp( self.param_, other.param_ )

class VirtualCablePortCliSaveMode( VirtualCablePortMode, CliSave.Mode ):
   def __init__( self, param ):
      VirtualCablePortMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )
      
   def __cmp__( self, other ):
      return cmp( self.param_, other.param_ )

CliSave.GlobalConfigMode.addCommandSequence( 'VirtualCable.global' )
CliSave.GlobalConfigMode.addChildMode( VirtualCableCliSaveMode, 
                                       after=[ IntfConfigMode ] )
VirtualCableCliSaveMode.addChildMode( VirtualCablePortCliSaveMode )
VirtualCableCliSaveMode.addCommandSequence( 'VirtualCable.config' )
VirtualCablePortCliSaveMode.addCommandSequence( 'VirtualCable.config.port' )

@CliSave.saver( "VirtualCable::Config", "virtualcable/config" )
def saveVirtualCableConfig( configDir, root, sysdbRoot, options ):

   if configDir.tpid == 0 and len( configDir.groups ) == 0:
      if options.saveAll:
         # If the config is empty, add no virtual-cable then return       
         cmds = root[ 'VirtualCable.global' ]
         cmds.addCommand( 'no virtual-cable' )
      return
   
   mode = root[ VirtualCableCliSaveMode ].getSingletonInstance()
   cmds = mode[ 'VirtualCable.config' ]

   if configDir.tpid != 0:
      cmds.addCommand( "tpid %#06x" % configDir.tpid )

   groups = configDir.groups.keys()

   for group in groups:
      groupMode = mode[ VirtualCablePortCliSaveMode
                                    ].getOrCreateModeInstance( group )
      # pylint: disable-msg=W0612
      groupCmds = groupMode[ 'VirtualCable.config.port' ]
      groupConfig = configDir.groups[ group ]
      
      vcIntfs = groupConfig.vcableIntf.keys()
      vcIntfs.sort()
      
      for vcIntf in vcIntfs:
         vcConfig = groupConfig.vcableIntf.get( vcIntf )
         if vcConfig:
            groupCmds.addCommand( 'loopback-port %s mux-id %d' % 
                                       ( vcIntf, vcConfig.muxId ) )
         

