#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from IntfCliSave import IntfConfigMode
from CliMode.UplinkFailureDetection import LinkStateMode

class LinkStateConfigMode( LinkStateMode, CliSave.Mode ):

   def __init__( self, param ):
      LinkStateMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( LinkStateConfigMode,
                                       before=[ IntfConfigMode ] )
LinkStateConfigMode.addCommandSequence( 'UplinkFailureDetection.config' )
IntfConfigMode.addCommandSequence( 'UplinkFailureDetection.ethIntf' )

@CliSave.saver( 'UplinkFailureDetection::GroupConfig',
                'interface/errdisable/uplinkFailureDetection/config',
                attrName='group' )
def saveUplinkFailureDetectionConfig( groupConfig, root, sysdbRoot, options ):
   groupName = groupConfig.name
   mode = root[ LinkStateConfigMode ].getOrCreateModeInstance( groupName )
   cmds = mode[ 'UplinkFailureDetection.config' ]
   if options.saveAll or groupConfig.minLinks != groupConfig.minLinksDefault:
      cmds.addCommand( "links minimum %d" % groupConfig.minLinks )
   if options.saveAll or ( groupConfig.recoveryDelay !=
                           groupConfig.recoveryDelayDefault ):
      cmds.addCommand( "recovery delay %d" % groupConfig.recoveryDelay )
   for uplink in groupConfig.intfsToMonitor:
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( uplink )
      ethIntfCmds = mode[ 'UplinkFailureDetection.ethIntf' ]
      ethIntfCmds.addCommand( "link tracking group %s upstream" % groupName )
   for downlink in groupConfig.intfsToDisable:
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( downlink )
      ethIntfCmds = mode[ 'UplinkFailureDetection.ethIntf' ]
      ethIntfCmds.addCommand( "link tracking group %s downstream" % groupName )
