# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'ObjectTracking.config' )

@CliSave.saver( 'Tracking::Config', 'tracking/config' )
def saveTrackingCliConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'ObjectTracking.config' ]
   for intfObjConfig in entity.interfaceObjectConfig.values():
      cmds.addCommand( 'track %s interface %s line-protocol'
                       % (intfObjConfig.name, intfObjConfig.intfName) )
