# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

from CliSavePlugin.Controllerdb import ( CvxConfigMode,
                                         controllerConfigPath,
                                         getClusterName )
from CliMode.Topology import TopologyMode

#------------------------------------------------------------------------------
# Topology Mode Saver
#------------------------------------------------------------------------------

class TopologyConfigSaveMode( TopologyMode, CliSave.Mode ):
   def __init__( self, param ):
      TopologyMode.__init__( self )
      CliSave.Mode.__init__( self, param )

CvxConfigMode.addChildMode( TopologyConfigSaveMode,
                            after=[ 'cvx' ] )

TopologyConfigSaveMode.addCommandSequence( 'topology.config' )

@CliSave.saver( 'NetworkTopologyAggregatorV3::Config',
                'topology/aggregator/config',
                requireMounts=( controllerConfigPath, 'cli/config' ) )
def saveTopologyAggConfig( entity, root, sysdbRoot, options, requireMounts,
                           commentKey='cvx-topology' ):
   cmds = []
   staticEdgeCmd = 'network physical-topology switch %s interface %s neighbor %s'
   for edge in entity.staticEdge:
      cmd = staticEdgeCmd % ( edge.fromHost, edge.fromPort, edge.toHost )
      if edge.toPort != "":
         cmd += ' neighbor-interface %s' % edge.toPort
      cmds.append( cmd )

   if cmds or commentKey in requireMounts[ 'cli/config' ].comment:
      clusterName = getClusterName( requireMounts[ controllerConfigPath ] )
      cvxMode = root[ CvxConfigMode ].getOrCreateModeInstance(
         CvxConfigMode.modeName( clusterName ) )
      topologyMode = cvxMode[ TopologyConfigSaveMode ].getOrCreateModeInstance( 
            'cvx-topology' )
      cmdSeq = topologyMode[ 'topology.config' ]

      for cmd in cmds:
         cmdSeq.addCommand( cmd )
