# Copyright (c) 2008, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, Management, Tac
from IpLibConsts import DEFAULT_VRF
from CliMode.VrfConfig import VrfConfigMode

class TelnetConfigMode( Management.MgmtConfigMode ):
   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( TelnetConfigMode )
TelnetConfigMode.addCommandSequence( 'Mgmt.telnet' )

class TelnetVrfConfigMode( VrfConfigMode, CliSave.Mode ):

   def __init__( self, param ):
      VrfConfigMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

TelnetConfigMode.addChildMode( TelnetVrfConfigMode )
TelnetVrfConfigMode.addCommandSequence( 'Mgmt.telnet.vrf' )

@CliSave.saver( 'Mgmt::Telnet::Config', 'mgmt/telnet/config' )
def saveTelnet( telnetConfig, root, sysdbRoot, options ):
   mode = root[ TelnetConfigMode ].getOrCreateModeInstance( 'telnet' )
   cmds = mode[ 'Mgmt.telnet' ]
   if telnetConfig.serverState != telnetConfig.serverStateDefault or options.saveAll:
      cmds.addCommand( "%sshutdown" % \
            ( "no " if telnetConfig.serverState == "enabled" else "" ) )

   if telnetConfig.idleTimeout.timeout != \
          telnetConfig.idleTimeout.defaultTimeout or options.saveAll:
      cmds.addCommand( "idle-timeout %s" %
                       ( int( telnetConfig.idleTimeout.timeout / 60 ) ) )

   if ( telnetConfig.sessionLimit != telnetConfig.sessionLimitDefault 
        or options.saveAll ):
      cmds.addCommand( "session-limit %d" % telnetConfig.sessionLimit )

   if ( telnetConfig.sessionLimitPerHost != telnetConfig.sessionLimitPerHostDefault
        or options.saveAll ):
      cmds.addCommand( "session-limit per-host %d" %
                       telnetConfig.sessionLimitPerHost )

   for ( vrfName, vrfConfig ) in telnetConfig.vrfConfig.iteritems():
      vrfMode = mode[ TelnetVrfConfigMode ].getOrCreateModeInstance(
         ( vrfName, 'telnet', telnetConfig ) )
      cmds = vrfMode[ 'Mgmt.telnet.vrf' ]
      if vrfConfig.serverState == "disabled":
         cmds.addCommand( "shutdown" )
      elif vrfConfig.serverState == "enabled":
         cmds.addCommand( "no shutdown" )
      elif vrfConfig.serverState == "globalDefault" and options.saveAll:
         cmds.addCommand( "default shutdown" )

@CliSave.saver( 'Acl::Input::CpConfig', 'acl/cpconfig/cli' )
def saveTelnetIpAclRev1( aclCpConfig, root, sysdbRoot, options, requireMounts ):
   def saveServiceAcl( aclType ):
      for vrfName, serviceAclVrfConfig in \
            aclCpConfig.cpConfig[ aclType ].serviceAcl.iteritems():
         serviceConfig = serviceAclVrfConfig.service.get( 'telnet' )
         if serviceConfig: 
            if serviceConfig.aclName != '': 
               mode = root[ TelnetConfigMode ].getOrCreateModeInstance( 'telnet' )
               cmds = mode[ 'Mgmt.telnet' ]
               if vrfName == DEFAULT_VRF:
                  cmds.addCommand( '%s access-group %s in' %
                                    ( aclType, serviceConfig.aclName ) )
               else:
                  cmds.addCommand( '%s access-group %s vrf %s in' %
                                    ( aclType, serviceConfig.aclName, vrfName ) )
            elif options.saveAll and serviceConfig.defaultAclName != '':
               mode = root[ TelnetConfigMode ].getOrCreateModeInstance( 'telnet' )
               cmds = mode[ 'Mgmt.telnet' ]
               if vrfName == DEFAULT_VRF:
                  cmds.addCommand( '%s access-group %s in' %
                                    ( aclType, serviceConfig.defaultAclName ) )
               else:
                  cmds.addCommand( '%s access-group %s vrf %s in' %
                                    ( aclType, serviceConfig.defaultAclName,
                                      vrfName ) )
   for t in ( 'ip', 'ipv6' ):
      saveServiceAcl( t )
