#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliSave
from CliSavePlugin import Management
from CliMode.TechSupport import TechSupportPolicyMode

class TechSupportConfigMode( Management.MgmtConfigMode ):
   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( TechSupportConfigMode )
TechSupportConfigMode.addCommandSequence( 'Mgmt.tech-support' )

class TechSupportPolicyConfigMode( TechSupportPolicyMode, CliSave.Mode ):
   def __init__( self, param ):
      TechSupportPolicyMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

TechSupportConfigMode.addChildMode( TechSupportPolicyConfigMode )
TechSupportPolicyConfigMode.addCommandSequence( 'Mgmt.tech-support.policy' )

def getMgmtTechSupportPolicyCmds( root ):
   mode = root[ TechSupportConfigMode ].getOrCreateModeInstance(
      'tech-support' )
   mode = mode[ TechSupportPolicyConfigMode ].getOrCreateModeInstance(
      'show tech-support' )
   return mode[ 'Mgmt.tech-support.policy' ]

@CliSave.saver( 'Cli::Config', 'cli/config' )
def saveTechSupport( techSupportConfig, root, sysdbRoot, options ):
   if techSupportConfig.excludedShowTechCmds:
      cmds = getMgmtTechSupportPolicyCmds( root )
      for c in techSupportConfig.excludedShowTechCmds:
         cmds.addCommand( 'exclude command %s' % c )
   if techSupportConfig.excludedShowTechJsonCmds:
      cmds = getMgmtTechSupportPolicyCmds( root )
      for c in techSupportConfig.excludedShowTechJsonCmds:
         cmds.addCommand( 'exclude command json %s' % c )
   if techSupportConfig.includedShowTechCmds:
      cmds = getMgmtTechSupportPolicyCmds( root )
      for c in techSupportConfig.includedShowTechCmds:
         cmds.addCommand( 'include command %s' % c )
