# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, TcpdumpLib

CliSave.GlobalConfigMode.addCommandSequence( 'Tcpdump.config' )

@CliSave.saver( 'Tcpdump::Config', 'sys/tcpdump/config' )
def saveConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'Tcpdump.config' ]

   sessions = entity.session.values()
   for session in sorted( sessions, key=lambda session: session.name ):
      sessionCmd = "tcpdump session %s" % session.name
      for attr in sorted( TcpdumpLib.sessionAttributeMap() ):
         if attr == 'filter':
            continue
         value = TcpdumpLib.getTcpdumpCliParameter( session, attr, options.saveAll )
         if value is not None:
            sessionCmd += " " + value
      # Process filter at the end of the command
      value = TcpdumpLib.getTcpdumpCliParameter( session, 'filter', options.saveAll )
      if value is not None:
         sessionCmd += " " + value
      cmds.addCommand( sessionCmd )
      if options.saveAll or not session.enabled:
         sessionShutdownCmd = ''
         if session.enabled:
            sessionShutdownCmd += 'no '
         sessionShutdownCmd += 'tcpdump session %s shutdown' % session.name
         cmds.addCommand( sessionShutdownCmd )
