# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac, CliSave
from IntfCliSave import IntfConfigMode
import EthIntfUtil

IntfConfigMode.addCommandSequence( 'Ebra.taggedPdu', after=[ 'Ebra.switchport' ] )

#-------------------------------------------------------------------------------
# Saves the state of an Bridging::TaggedPduIntfConfig object.
#-------------------------------------------------------------------------------
def saveTaggedPduIntfConfig( entity, root, sysdbRoot, saveAll ):
   mode = root[ IntfConfigMode ].getOrCreateModeInstance( entity.intfId )
   cmds = mode[ 'Ebra.taggedPdu' ]

   # Display defaults on all ports for saveAll
   if entity.acceptTaggedPdu:
      cmds.addCommand( 'l2-protocol encapsulation dot1q vlan %d' %
         entity.allowedTag )
   elif saveAll:
      cmds.addCommand( 'no l2-protocol encapsulation dot1q vlan 0' )
 
@CliSave.saver( 'L2Protocol::TaggedPduIntfConfigDir',
                'l2protocol/taggedPduIntfConfigDir',
                requireMounts = ( 'bridging/config', ) )
def saveTaggedPduConfig( entity, root, sysdbRoot, options,
                         requireMounts ):
   if options.saveAll:
      # Get all eligible switchports
      bridgingConfig = requireMounts[ 'bridging/config' ]
      cfgIntfNames = EthIntfUtil.allSwitchportNames( bridgingConfig,
                                                     includeEligible=True )
   else:
      cfgIntfNames = entity.taggedPduIntfConfig

   for intfName in cfgIntfNames:
      intfConfig = entity.taggedPduIntfConfig.get( intfName )
      if not intfConfig:
         if options.saveAll:
            intfConfig = Tac.newInstance( 'L2Protocol::TaggedPduIntfConfig',
                                          intfName )
         else:
            continue
      saveTaggedPduIntfConfig( intfConfig, root, sysdbRoot, options.saveAll )
