#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements CliSave for the tag commands
#-------------------------------------------------------------------------------
import CliSave
from IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( 'tag.intfConfig' )

@CliSave.saver( 'Tag::Config', 'tag/config' )
def saveIntfConfig( entity, root, sysdbRoot, options ):

   for intfName in entity.intfConfig:
      intfMode = root[ IntfConfigMode ].getOrCreateModeInstance( intfName )
      intfCmds = intfMode[ 'tag.intfConfig' ]
      intfConfig = entity.intfConfig[ intfName ]
      for tagName in intfConfig.tag:
         configCmdPrefix = 'tag '
         configCmd = configCmdPrefix + tagName
         intfCmds.addCommand( configCmd )
