#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( "Stage.blockStage" )

@CliSave.saver( "Stage::StageGlobalConfig", "stage/stageGlobalConfig" )
def saveStageGlobalConfig( entity, root, sysdbRoot, options ):
   #-------------------------------------------------------------------------
   # stage-config <stageClass> block <stage>
   #-------------------------------------------------------------------------
   cmds = root[ "Stage.blockStage" ]
   for stageInfo, blocked in entity.doNotStartStage.iteritems():
      if blocked:
         cmds.addCommand( "stage-config %s block %s" % (
               stageInfo.stageClass, stageInfo.stage ) )
