# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from AclCliLib import dscpAclNames
from CliMode.SrTeColorMapping import SrTeColorDscpModeBase
from CliSavePlugin.SrTePolicyCliSave import (
      SrTeMode,
      getOrCreateSrTeModeInst,
   )
from MultiRangeRule import multiRangeToCanonicalString
import CliSave

class SrTeColorDscpMode( SrTeColorDscpModeBase, CliSave.Mode ):
   def __init__( self, param ):
      SrTeColorDscpModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, param )

SrTeMode.addChildMode( SrTeColorDscpMode )
SrTeColorDscpMode.addCommandSequence( 'SrTePolicy.color-dscp.config' )

_dscpValueToName = {}
for _dscpName, ( _dscpValue, _ ) in dscpAclNames.iteritems():
   _dscpValueToName[ _dscpValue ] = _dscpName

def _dscpMixedTypeCmp( a, b ):
   '''
   Sort objects of the same type in their natural (object-defined) order.

   For strings, make them sort at a lower value than all other types.  For example,
   with [3, 'af12', 1, 'ef'], produce ['af12', 'ef', 1, 3].
   '''
   if type( a ) != type( b ):
      return -1 if isinstance( a, str ) else 1
   return cmp( a, b )

def getOrCreateColorDscpMapModeInst( root ):
   p = getOrCreateSrTeModeInst( root )
   return p[ SrTeColorDscpMode ].getOrCreateModeInstance( 'colorDscpMapInst' )

@CliSave.saver( 'SrTePolicy::ColorDscpMap',
                'te/segmentrouting/color-dscp/config' )
def saveColorDscpMappings( config, root, sysdbRoot, options, requireMounts ):
   if config.colorToDscp:
      colorDscpMappingsMode = getOrCreateColorDscpMapModeInst( root )
      cmds = colorDscpMappingsMode[ 'SrTePolicy.color-dscp.config' ]
      cmdFormat = 'color {color} dscp {valuesStr}'
      for color in sorted( config.colorToDscp ):
         dscpList = config.colorToDscp[ color ]
         if dscpList.defaultDscps:
            cmds.addCommand( 'color {color} default'.format( color=color ) )
            continue
         haveSymbolic = any( dscpList.cliSaveUseSymbolic_i.values() )
         if haveSymbolic:
            dscpValues = []
            for value in dscpList.dscp:
               if dscpList.cliSaveUseSymbolic_i.get( value, False ):
                  dscpValues.append( _dscpValueToName[ value ] )
               else:
                  dscpValues.append( value )
            # Use the _dscpMixedTypeCmp comparison function so that we show the
            # symbolic DSCP values before the raw integer values.  This choice
            # of ordering is arbitrary.
            dscpValuesStr = ' '.join(
                  map( str, sorted( dscpValues, cmp=_dscpMixedTypeCmp ) ) )
         else:
            dscpValuesStr = multiRangeToCanonicalString( dscpList.dscp.keys() )
         cmds.addCommand( cmdFormat.format( color=color, valuesStr=dscpValuesStr ) )
