# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

speedGroupSeqName = 'SpeedGroup.config'
CliSave.GlobalConfigMode.addCommandSequence( speedGroupSeqName )

@CliSave.saver( 'Tac::Dir', 'interface/archer/config/eth/phy/speedgroup/slice' )
def saveSpeedGroupConfig( sliceDir, root, sysdbRoot, options ):
   cmds = root[ speedGroupSeqName ]
   enumToToken = { 'compatibility10g' : '10g',
                   'compatibility25g' : '25g',
                   'compatibility50g' : '50g' }
   for speedGroupConfigDir in sliceDir.itervalues():
      for speedGroup, speedGroupConfig in sorted(
            speedGroupConfigDir.group.iteritems() ):
         compatibilities = []
         for compatibility in speedGroupConfig.setting.iterkeys():
            compatibilities.append( enumToToken[ compatibility ] )
         compatString = ' '.join( compatibilities )
         if compatString:
            cmds.addCommand( 'hardware speed-group%s serdes %s' % ( speedGroup,
                                                                    compatString ) )
         elif options.saveAll:
            cmds.addCommand( 'no hardware speed-group%s serdes' % speedGroup )
