#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac

from CliMode.SharedSecretProfileMode import SharedSecretProfileCliMode
from CliSavePlugin.Security import SecurityConfigMode
from ReversibleSecretCli import encodeKey

class SharedSecretProfileMode( SharedSecretProfileCliMode, CliSave.Mode ):
   def __init__( self, param ):
      SharedSecretProfileCliMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

SecurityConfigMode.addChildMode( SharedSecretProfileMode,
                                 after=[ 'Mgmt.security' ] )
SharedSecretProfileMode.addCommandSequence(
   'Mgmt.security.sh-sec-prof.profile' )
SharedSecretProfileMode.addCommandSequence(
   'Mgmt.security.sh-sec-prof' )

@CliSave.saver( 'Mgmt::Security::SharedSecretProfile::Config',
                'mgmt/security/sh-sec-prof/config' )
def saveSharedSecretProfileConfig( entity, root, sysdbRoot, options ):
   for name, profile in entity.profile.iteritems():
      secMode = root[ SecurityConfigMode ].getOrCreateModeInstance( 'security' )
      mode = secMode[ SharedSecretProfileMode ].getOrCreateModeInstance( name )
      cmds = mode[ 'Mgmt.security.sh-sec-prof.profile' ]

      for secret in profile.secret.keys():
         cmds.addCommand(
            'secret %s 7 %s receive-lifetime %s transmit-lifetime %s' %
            ( secret.id,
              CliSave.sanitizedOutput( options, encodeKey( secret.secret,
                                                           algorithm='MD5' ) ),
              secret.receiveLifetime.stringValue,
              secret.transmitLifetime.stringValue ) )
