# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'SflowAccel.config' )

@CliSave.saver( 'Hardware::SflowAccel::Config', 'hardware/sflowAccel/config' )
def saveSflowAccelConfig( entity, root, sysdbRoot, options, requireMounts ):

   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail

   cmds = root[ 'SflowAccel.config' ]

   sflowAccelEn = entity.sflowAccelEnabled

   if sflowAccelEn == 'enabledByCli':
      cmds.addCommand( 'sflow hardware acceleration' )
   elif sflowAccelEn == 'disabledByCli':
      cmds.addCommand( 'no sflow hardware acceleration' )
   elif sflowAccelEn == 'platformDefault' and ( saveAll or saveAllDetail ):
      cmds.addCommand( 'default sflow hardware acceleration' )

   for lc in entity.disableHwAccelInSlot:
      if entity.disableHwAccelInSlot[ lc ]:
         cmds.addCommand( 'no sflow hardware acceleration module linecard {}'
                          .format( lc ) )

   if entity.sampleRate != entity.sampleRateDefault:
      cmds.addCommand( 'sflow hardware acceleration sample {}'
                       .format( entity.sampleRate ) )
   elif saveAll or saveAllDetail:
      cmds.addCommand( 'default sflow hardware acceleration sample' )

   cliToken = {
      'profileSflowAccelV2' : 'sflowaccel-v2',
   }
   if entity.profile != entity.profileDefault:
      cmds.addCommand( 'sflow hardware acceleration profile {}'
                       .format( cliToken[ entity.profile ] ) )
   elif saveAll or saveAllDetail:
      cmds.addCommand( 'no sflow hardware acceleration profile' )

   if ( entity.datagramTransmissionThreshold !=
        entity.defaultDatagramTransmissionThreshold ):
      cmd = 'sflow hardware acceleration datagram threshold transmission {} {}'
      cmds.addCommand( cmd.format( entity.datagramTransmissionThreshold.value,
                                   entity.datagramTransmissionThreshold.unit ) )
   elif saveAll or saveAllDetail:
      cmds.addCommand( 'no sflow hardware acceleration datagram' )
