#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from QosTypes import tacRateUnit
import Tac

CliSave.GlobalConfigMode.addCommandSequence( 'Sfe.config' )

@CliSave.saver( "Sfe::BessdCliConfig", "bess/cli/config" )
def saveBessDebugConfig( entity, root, sysdbRoot, options ):
   cmds = root[ "Sfe.config" ]

   if entity.traceConfig:
      cmds.addCommand( "platform sfe debug trace %s" % entity.traceConfig )

   if entity.vlogConfig:
      cmds.addCommand( "platform sfe debug vlog %s" % entity.vlogConfig )
   if entity.hashFuncId:
      cmds.addCommand( "ip load-sharing sfe hash %d" % entity.hashFuncId )

   cpuReceiveLimitDefault = Tac.Value( "Sfe::CpuReceiveLimitConfig" )
   if cpuReceiveLimitDefault != entity.cpuReceiveLimit or options.saveAll:
      if entity.cpuReceiveLimit.unit == tacRateUnit.rateUnitKbps:
         cliRateUnit = 'kbps'
      else:
         cliRateUnit = 'mbps'
      cmds.addCommand( "platform sfe control-plane receive-limit %d %s" %
                       ( entity.cpuReceiveLimit.value, cliRateUnit ) )
