# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

serviceConfigCmdSeqName = "SysMgr.serviceConfig"

CliSave.GlobalConfigMode.addCommandSequence( serviceConfigCmdSeqName )

@CliSave.saver( "System::ServiceConfig", 'sys/service/config' )
def saveConfig( config, root, sysdbRoot, options ):
   cmds = root[ serviceConfigCmdSeqName ]
   saveAll = options.saveAll

   if config.timeInRunningConfig != config.timeInRunningConfigDefault or saveAll:
      cmds.addCommand( "%sservice running-config timestamp"
                       % ( "" if config.timeInRunningConfig else "no " ) )

   if ( config.useSessionInCopyRunningConfig !=
        config.useSessionInCopyRunningConfigDefault
        or saveAll ):
      cmds.addCommand( "%sservice running-config copy use-config-session"
                       % ( "" if config.useSessionInCopyRunningConfig
                           else "no " ) )
