# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Management

class SecurityConfigMode( Management.MgmtConfigMode ):
   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, "security" )

CliSave.GlobalConfigMode.addChildMode( SecurityConfigMode )
SecurityConfigMode.addCommandSequence( 'Mgmt.security' )

@CliSave.saver( 'Mgmt::Security::Config', 'mgmt/security/config' )
def saveSecurity( securityConfig, root, sysdbRoot, options ):
   mode = root[ SecurityConfigMode ].getOrCreateModeInstance( 'security' )
   cmds = mode[ 'Mgmt.security' ]
   hwEntEnabled = securityConfig.entropySourceHardware
   havegeEnabled = securityConfig.entropySourceHaveged
   if ( hwEntEnabled == securityConfig.defaultEntropySourceHardware
         and havegeEnabled == securityConfig.defaultEntropySourceHaveged ):
      if options.saveAll:
         cmds.addCommand( 'no entropy source' )
   else:
      sourcesList = []
      if hwEntEnabled:
         sourcesList.append( "hardware" )
      if havegeEnabled:
         sourcesList.append( "haveged" )
      cmd = "entropy source {entSources}"
      cmds.addCommand( cmd.format( entSources=" ".join( sourcesList ) ) )

   if ( securityConfig.useEntropyServer !=
        securityConfig.defaultUseEntropyServer ) or options.saveAll:
      cmd = 'entropy source hardware exclusive'
      if not securityConfig.useEntropyServer:
         cmd = 'no ' + cmd
      cmds.addCommand( cmd )

   if ( securityConfig.minPasswordLength != securityConfig.defaultMinPasswordLength
        or options.saveAll ):
      cmd = 'password minimum length'
      if securityConfig.minPasswordLength == 0:
         cmd = 'no ' + cmd
      else:
         cmd += ' %d' % securityConfig.minPasswordLength
      cmds.addCommand( cmd )

   if ( securityConfig.commonKeyEnabled != securityConfig.commonKeyEnabledDefault 
        or options.saveAll ):
      cmd = 'password encryption-key common'
      if securityConfig.commonKeyEnabled == False:
         cmd = 'no ' + cmd
      cmds.addCommand( cmd )

   if securityConfig.enforceSignature or options.saveAll:
      cmd = "signature-verification extension"
      if not securityConfig.enforceSignature:
         cmd = "no " + cmd
      elif ( securityConfig.sslProfile != securityConfig.defaultSslProfile or
             options.saveAll ):
         cmd += " ssl profile %s" % securityConfig.sslProfile
      cmds.addCommand( cmd )

   for protocol in sorted( securityConfig.blockedNetworkProtocols ):
      cmds.addCommand( "network client protocol %s disabled" % protocol )
