#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliSave
from CliMode.SamplePolicy import SamplePolicyModeBase
from CliSavePlugin.TrafficPolicyCliSave import TrafficPolicySaver
from CliSavePlugin.TrafficPolicyCliSave import ( MatchRuleSaveMode, ActionsSaveMode )

class SamplePolicySaveMode( SamplePolicyModeBase, CliSave.Mode ):
   def __init__( self, param ):
      SamplePolicyModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class SamplePolicySaver( TrafficPolicySaver ):
   trafficPolicyMode = SamplePolicySaveMode
   matchRuleMode = MatchRuleSaveMode
   actionsRuleMode = ActionsSaveMode

   def __init__( self, entity, root, sysdbRoot, options, requireMounts, feature,
                 commentKey ):
      TrafficPolicySaver.__init__( self, entity, root, sysdbRoot, options,
                                   requireMounts, feature, commentKey )
      self.policyMapType = 'sample-policy'
      self.commentKey = commentKey

   def matchModeCmds( self, matchMode ):
      return NotImplementedError

   def actionModeCmds( self, actionsMode ):
      return NotImplementedError
