# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliSave
from CliSavePlugin.RouterGeneralCliSave import RouterGeneralCliSaveMode

@CliSave.saver( 'Routing::Hardware::Config',
                'routing/hardware/config' )
def saveDynPolicyRoutesConfig( entity, root, sysdbRoot, options ):
   saveAll = options.saveAll

   # Don't print anything when configuration has default values
   # unless it's saveAll
   if not saveAll and not entity.hwFastFailoverEnabled:
      return

   mode = root[ RouterGeneralCliSaveMode ].getOrCreateModeInstance( 'generalconfig' )
   cmds = mode[ 'config' ]

   cmdStr = 'hardware next-hop fast-failover'
   if entity.hwFastFailoverEnabled:
      cmd = cmdStr
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )
