# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, Tracing
from CliSavePlugin.IraCliSave import RouterKernelCliSaveMode
from IpLibConsts import DEFAULT_VRF

__defaultTraceHandle__ = Tracing.Handle( 'AclCliSave' )

@CliSave.saver( 'AclAgent::KernelProtoConfig', 'routing/kernel/protocol' )
def saveRouterKernelProtoConfig( entity, root, sysdbRoot, options ):

   saveUdp = entity.udpSendUnreachable != entity.udpSendUnreachableDefaultFalse \
               or options.saveAll
   if not saveUdp:
      return

   vrfMode = root[ RouterKernelCliSaveMode ].\
             getOrCreateModeInstance( ( DEFAULT_VRF ) )

   cmds = vrfMode[ 'Router.kernel' ]
   if saveUdp:
      if entity.udpSendUnreachable:
         cmds.addCommand( 'protocol udp unknown-port send-unreachable always' )
      else:
         cmds.addCommand( 'no protocol udp unknown-port send-unreachable' )

