# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliSave
from CliSavePlugin.RouterGeneralCliSave import RouterGeneralCliSaveMode
from Toggles import RouteMapToggleLib

@CliSave.saver( 'Routing::RouteMap::Config', 'routing/routemap/config' )
def saveCommandRouteMapPolicyReferUnconfigError( entity, root, sysdbRoot, options ):
   if not RouteMapToggleLib.toggleCommandUnconfReferencesRouteMapEnabled():
      return

   saveAll = options.saveAll

   # Don't print anything when configuration has default value
   # unless it's saveAll
   if not saveAll and not entity.routeMapPolicyReferenceUnconfiguredError:
      return

   mode = root[ RouterGeneralCliSaveMode ].getOrCreateModeInstance( 'generalconfig' )
   cmds = mode[ 'config' ]

   cmdStr = 'command route-map policy reference unconfigured action error'
   if entity.routeMapPolicyReferenceUnconfiguredError:
      cmds.addCommand( cmdStr )
   elif saveAll:
      cmds.addCommand( "no " + cmdStr )
