# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Tac
import CliSave
from CliSavePlugin.RouterGeneralCliSave import RouterGeneralCliSaveMode
import Toggles.RoutingLibToggleLib

ecmpState = Tac.Type('Routing::General::StaticRouteEcmpState')

@CliSave.saver( 'Routing::General::Config', 'routing/general/config/global' )
def saveStaticRouteEcmpStateConfig( entity, root, sysdbRoot, options ):
   if not Toggles.RoutingLibToggleLib.toggleStrictEcmpEnabled():
      return

   saveAll = options.saveAll

   # Don't print anything when configuration has default value
   # unless it's saveAll
   if not saveAll and entity.staticRouteEcmpState == ecmpState.strict:
      return

   mode = root[ RouterGeneralCliSaveMode ].getOrCreateModeInstance( 'generalconfig' )
   cmds = mode[ 'config' ]

   cmdStr = 'route ecmp static relaxed'
   if entity.staticRouteEcmpState != ecmpState.strict:
      cmds.addCommand( cmdStr )
   elif saveAll:
      cmds.addCommand( "no " + cmdStr )
