# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from CliMode.RouteCacheMode import RouterGeneralRouteCacheBaseMode
from CliSavePlugin.RouterGeneralCliSave import RouterGeneralCliSaveMode
import CliSave

class RouterGeneralRouteCacheCliSaveMode( RouterGeneralRouteCacheBaseMode,
                                          CliSave.Mode ):

   def enterCmd( self ):
      return 'route cache'

   def __init__( self, param ):
      RouterGeneralRouteCacheBaseMode.__init__( self )
      CliSave.Mode.__init__( self, param )

RouterGeneralCliSaveMode.addChildMode( RouterGeneralRouteCacheCliSaveMode )
RouterGeneralRouteCacheCliSaveMode.addCommandSequence( 'routeCacheConfig' )

@CliSave.saver( 'RouteCache::CliConfig', 'routecache/cliconfig' )
def saveRouteCacheConfig( entity, root, sysdbRoot, options ):
   saveAll = options.saveAll

   def getOrCreateMode():
      parentMode = root[ RouterGeneralCliSaveMode ].getOrCreateModeInstance(
            'routeCacheConfig' )
      mode = \
         parentMode[ RouterGeneralRouteCacheCliSaveMode ].getOrCreateModeInstance(
            'routeCacheConfig' )

      return mode[ 'routeCacheConfig' ]

   thresholdCmd = \
         'hardware utilization threshold %s %d percent idle-limit %d seconds'

   if entity.thresholdConfig.thresholdLevelLowIdleTime != \
         entity.thresholdConfig.defaultThresholdLevelLowIdleTime or \
         entity.thresholdConfig.thresholdLevelLowHwUtilPercentage != \
         entity.thresholdConfig.defaultThresholdLevelLowHwUtilPercentage or \
         saveAll:
      cmds = getOrCreateMode()
      cmds.addCommand( thresholdCmd % ( 'low',
                        entity.thresholdConfig.thresholdLevelLowHwUtilPercentage,
                        entity.thresholdConfig.thresholdLevelLowIdleTime ) )

   if entity.thresholdConfig.thresholdLevelMediumIdleTime != \
         entity.thresholdConfig.defaultThresholdLevelMediumIdleTime or \
         entity.thresholdConfig.thresholdLevelMediumHwUtilPercentage != \
         entity.thresholdConfig.defaultThresholdLevelMediumHwUtilPercentage or \
         saveAll:
      cmds = getOrCreateMode()
      cmds.addCommand( thresholdCmd % ( 'medium',
                        entity.thresholdConfig.thresholdLevelMediumHwUtilPercentage,
                        entity.thresholdConfig.thresholdLevelMediumIdleTime ) )

   if entity.thresholdConfig.thresholdLevelHighIdleTime != \
         entity.thresholdConfig.defaultThresholdLevelHighIdleTime or \
         entity.thresholdConfig.thresholdLevelHighHwUtilPercentage != \
         entity.thresholdConfig.defaultThresholdLevelHighHwUtilPercentage or \
         saveAll:
      cmds = getOrCreateMode()
      cmds.addCommand( thresholdCmd % ( 'high',
                        entity.thresholdConfig.thresholdLevelHighHwUtilPercentage,
                        entity.thresholdConfig.thresholdLevelHighIdleTime ) )
