# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""
There are two different startup files that ribd can look at:
   - /persist/sys/ribd.ami: this contains a binary format AMI dump of both
                            customer-added configuration, and EOS-generated
                            configuration.  This file is historically
                            problematic, and is deprecated.
   - /mnt/flash/rib-startup: this contains a text list of configuration
                             commands that are applied via cliribd at
                             Rib agent start time.
"""

import CliSave, os

# prefix class name with '000' to make sure it always appears early in show
# running output
CliSave.GlobalConfigMode.addCommandSequence( '000Rib.config' )

ribAmi = '/persist/sys/ribd.ami'
ribStartup = '/mnt/flash/rib-startup'

# Since these files are not part of Sysdb,
# we use a simple saver with 'routing/config',
# a path which will always be config-mounted.
# This causes the saver to be called exactly once.
@CliSave.simpleSaver( 'routing/config' )
def saveRib( entity, root, sysdbRoot, options ):
   cmds = root[ '000Rib.config' ]
   if os.path.exists( ribAmi ):
      cmds.addCommand( '! NOTE: %s exists, which may' % ribAmi )
      cmds.addCommand( '! interfere with EOS operation.' )
      cmds.addCommand( '!' )
   if os.path.exists( ribStartup ):
      try:
         startup = file( ribStartup )
         cmds.addCommand( '! Additional Rib agent startup configuration:' )
         cmds.addCommand( '!' )
         for line in startup.readlines():
            cmds.addCommand( '!  ' + line.rstrip() )
      except IOError:
         cmds.addCommand( '! NOTE: %s exists but is not readable' % ribStartup )
      cmds.addCommand( '!' )
