# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac

from RouterGeneralCliSave import getRouterGeneralVrfModeCtx
from RouterGeneralCliSave import RouterGeneralVrfCliSaveMode

# pkgdeps: library RouteControl

RouteControlConstant = Tac.Type( 'Routing::RouteControl::Constant' )
 
RouterGeneralVrfCliSaveMode.addCommandSequence( 'ribRouteControl', 
                                                after=[ 'routes.dynamic' ] )

@CliSave.saver( 'Routing::RouteControl::Config',
                'routing/general/config/routeControl' )
def saveRibRouteControlConfig( entity, root, sysdbRoot, options ):
   if not len( entity.vrfConfig ):
      return

   for vrfName, vrfConf in entity.vrfConfig.iteritems():
      vrfMode = getRouterGeneralVrfModeCtx( root, vrfName )
      cmds = vrfMode[ 'ribRouteControl' ]

      # Save ipv4 fib policy
      if vrfConf.fibIpv4PolicyMap != RouteControlConstant.fibIpv4PolicyMapDefault:
         cmds.addCommand( 'rib ipv4 fib policy %s' % vrfConf.fibIpv4PolicyMap )
      elif options.saveAll:
         cmds.addCommand( 'no rib ipv4 fib policy' )

      # Save ipv6 fib policy
      if vrfConf.fibIpv6PolicyMap != RouteControlConstant.fibIpv6PolicyMapDefault:
         cmds.addCommand( 'rib ipv6 fib policy %s' % vrfConf.fibIpv6PolicyMap )
      elif options.saveAll:
         cmds.addCommand( 'no rib ipv6 fib policy' )

      # Save ipv4 resolution policy
      if vrfConf.resIpv4PolicyMap != RouteControlConstant.resIpv4PolicyMapDefault:
         saveCmd = 'rib ipv4 resolution policy %s' % vrfConf.resIpv4PolicyMap
         cmds.addCommand( saveCmd )
      elif options.saveAll:
         cmds.addCommand( 'no rib ipv4 resolution policy' )

      # Save ipv6 resolution policy
      if vrfConf.resIpv6PolicyMap != RouteControlConstant.resIpv6PolicyMapDefault:
         saveCmd = 'rib ipv6 resolution policy %s' % vrfConf.resIpv6PolicyMap
         cmds.addCommand( saveCmd )
      elif options.saveAll:
         cmds.addCommand( 'no rib ipv6 resolution policy' )
