#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Restconf import MgmtRestconfMode, RestconfTransportMode
from IpLibConsts import DEFAULT_VRF

class MgmtRestconfSaveMode( MgmtRestconfMode, CliSave.Mode ):
   def __init__( self, param ):
      MgmtRestconfMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class RestconfTransportSaveMode( RestconfTransportMode, CliSave.Mode ):
   def __init__( self, param ):
      RestconfTransportMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( MgmtRestconfSaveMode )
MgmtRestconfSaveMode.addCommandSequence( "Mgmt.restconf" )

MgmtRestconfSaveMode.addChildMode( RestconfTransportSaveMode )
RestconfTransportSaveMode.addCommandSequence( 'Mgmt.restconf.transport' )

@CliSave.saver( "Restconf::Config", "mgmt/restconf/config" )
def saveRestconf( restconfConfig, root, sysdbRoot, options ):
   for name in restconfConfig.endpoints:
      parentMode = root[
            MgmtRestconfSaveMode ].getOrCreateModeInstance( "api-restconf" )
      mode = parentMode[ RestconfTransportSaveMode ].getOrCreateModeInstance(
                           name )
      cmds = mode[ 'Mgmt.restconf.transport' ]
      endpoint = restconfConfig.endpoints[ name ]

      if not endpoint.enabled:
         cmds.addCommand( "shutdown" )
      elif options.saveAll:
         cmds.addCommand( "no shutdown" )

      if endpoint.sslProfile != '':
         cmds.addCommand( "ssl profile %s" % endpoint.sslProfile )
      elif options.saveAll:
         cmds.addCommand( 'no ssl profile' )

      if endpoint.port != endpoint.portDefault or options.saveAll:
         cmds.addCommand( "port %s" % endpoint.port )

      if endpoint.vrfName != DEFAULT_VRF or options.saveAll:
         cmds.addCommand( "vrf %s" % endpoint.vrfName )

      if endpoint.serviceAcl != '':
         cmds.addCommand( 'ip access-group %s' % endpoint.serviceAcl )
      elif options.saveAll:
         cmds.addCommand( 'no ip access-group' )

      if endpoint.qosDscp:
         cmds.addCommand( "qos dscp %s" % endpoint.qosDscp )
