# Copyright (c) 2006-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.RedSup import RedundancyMode, RedundancyFileReplMode

class RedundancyConfigMode( RedundancyMode, CliSave.Mode ):
   def __init__( self, param ):
      RedundancyMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( RedundancyConfigMode )
RedundancyConfigMode.addCommandSequence( "Redundancy" )

@CliSave.saver( 'Redundancy::RedundancyConfig', 'redundancy/config',
                requireMounts=( 'hardware/entmib', ) )
def saveRedSupConfig( config, root, sysdbRoot, options,
                      requireMounts ):
   # only do saveAll for modular dut
   if not options.saveAll or requireMounts[ 'hardware/entmib' ].chassis:
      mode = root[ RedundancyConfigMode ].getSingletonInstance()
      cmds = mode[ 'Redundancy' ]
      if config.protocol != config.defaultProtocol or options.saveAll:
         cmds.addCommand( 'protocol %s' % config.protocol )
      if config.globalStageCompletionTimeout != \
         config.globalStageCompletionTimeoutDefault or options.saveAll:
         if config.globalStageCompletionTimeout == 0:
            cmds.addCommand( 'no switchover completion timeout' )
         else:
            cmds.addCommand( 'switchover completion timeout %u' %  
                              config.globalStageCompletionTimeout )

class RedundancyFileReplConfigMode( RedundancyFileReplMode, CliSave.Mode ):
   def __init__( self, param ):
      RedundancyFileReplMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

RedundancyConfigMode.addChildMode( RedundancyFileReplConfigMode )
RedundancyFileReplConfigMode.addCommandSequence( "FileReplication" )

@CliSave.saver( 'Election::FileReplicationCliConfig',
                'redundancy/fileReplication/cli/config' )
def saveRedSupFileReplConfig( config, root, sysdbRoot, options, requireMounts ):
   mode = root[ RedundancyConfigMode ].getSingletonInstance()
   mode = mode[ RedundancyFileReplConfigMode ].getSingletonInstance()
   cmds = mode[ 'FileReplication' ]
   for path in sorted( config.path ):
      cmds.addCommand( 'path %s' % path )
