# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Rcf import ControlFunctionsBaseMode
from RouterGeneralCliSave import RouterGeneralCliSaveMode
from Toggles.RcfLibToggleLib import toggleRcfAgentEnabled

class ControlFunctionsMode( ControlFunctionsBaseMode, CliSave.Mode ):
   def __init__( self, param ):
      ControlFunctionsBaseMode.__init__( self )
      CliSave.Mode.__init__( self, param )

RouterGeneralCliSaveMode.addChildMode( ControlFunctionsMode )
ControlFunctionsMode.addCommandSequence( 'Rcf.config' )

#---------------------------------------------------------------------------------
#                        C L I      S A V E R S
#---------------------------------------------------------------------------------

rcfStatusPath = ( 'routing/rcf/status_ci' if toggleRcfAgentEnabled() else
                  'routing/rcf/status' )
@CliSave.saver( 'Rcf::Config', 'routing/rcf/config',
                requireMounts=( rcfStatusPath, ) )
def saveRcfConfig( rcfConfig, root, sysdbRoot, options, requireMounts ):
   if not rcfConfig.rcfText and not options.saveAll:
      return
   status = requireMounts[ rcfStatusPath ]

   routerGeneralMode = root[ RouterGeneralCliSaveMode ].\
         getOrCreateModeInstance( 'generalconfig' )
   controlFunctionsMode = routerGeneralMode[ ControlFunctionsMode ].\
         getSingletonInstance()
   cmds = controlFunctionsMode[ 'Rcf.config' ]
   if rcfConfig.lastPulledUrl:
      cmds.addCommand( 'code source pulled-from %s %s' % ( rcfConfig.lastPulledUrl,
                        'edited' if rcfConfig.editSincePull else '' ) )
   if rcfConfig.rcfText:
      if not status.active:
         cmds.addCommand( '! Routing control function code is inactive because '
                          'it failed to compile.' )
         cmds.addCommand( '! Use "show router rcf errors startup" to see the '
                          'compilation errors.' )
      rcfText = "code" + "\n" + rcfConfig.rcfText + "EOF"
      if options.showJson:
         cmds.addCommand( rcfText )
      else:
         for line in rcfText.split( "\n" ):
            cmds.addCommand( line )
   elif options.saveAll:
      cmds.addCommand( "no code" )
