#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'QosSnmp.config' )

@CliSave.saver( 'QosSnmp::QosMibConfig', 'snmp/qos/config' )
def saveQosMibCliConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'QosSnmp.config' ]
   if entity.counterUpdateInterval != Tac.endOfTime:
      cmds.addCommand( 'snmp-server qosmib counter-interval %d' %
                       entity.counterUpdateInterval )
