# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliSave
import Toggles.PowerManagerToggleLib as PowerManagerToggles

CliSave.GlobalConfigMode.addCommandSequence( 'Power.global' )

@CliSave.saver( 'PowerManager::PowerManagerCliConfig',
                'environment/archer/power/config/powerManagerCliConfig' )
def savePowerManager( entity, root, sysdbRoot, options ):
   cmds = root[ 'Power.global' ]

   if entity.powerBudget != float( "inf" ):
      cmds.addCommand( 'power budget %d watts' % ( entity.powerBudget ) )
   elif entity.powerBudget == float( "inf" ) and options.saveAll:
      cmds.addCommand( 'no power budget' )
   if entity.mode == 'warn':
      cmds.addCommand( 'power budget exceeded action warn' )
   elif entity.mode == 'strict' and options.saveAll:
      cmds.addCommand( 'power budget exceeded action hold-down' )

@CliSave.saver( 'Hardware::PowerSupply::CliConfig',
                'hardware/powerSupply/config/cli' )
def savePowerThreshold( entity, root, sysdbRoot, options ):
   cmds = root[ 'Power.global' ]
   powerToggle = PowerManagerToggles.togglePowerManagementModularEnabled()
   if powerToggle:
      if entity.powerThreshold != float( "inf" ):
         cmds.addCommand( 'power threshold %d watts' % ( entity.powerThreshold ) )
      elif entity.powerThreshold == float( "inf" ) and options.saveAll:
         cmds.addCommand( 'no power threshold' )
