# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
# import LazyMount

CliSave.GlobalConfigMode.addCommandSequence( 'Power.global' )

@CliSave.saver( 'Hardware::PowerSupply::CliConfig',
                'hardware/powerSupply/config/cli' )
def savePowerPollInterval( entity, root, sysdbRoot, options ):
   cmds = root[ 'Power.global' ]

   if entity.pollInterval != entity.defaultPollInterval or \
         options.saveAll:
      cmds.addCommand( 'power poll-interval %d' % ( entity.pollInterval ) )

## Can probably be deleted.  Only commenting out for now, in case there's some
## issue that I've overlooked.
# def Plugin( entityManager ):
#    LazyMount.mount( entityManager,
#          "hardware/powerSupply/slot/config", 
#          "Hardware::PowerSupplySlot::Config",
#          "r" )
