# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac
from CliSavePlugin.Security import SecurityConfigMode
from CliMode.Pki import PkiProfileMode

Constants = Tac.Type( "Mgmt::Security::Ssl::Constants" )

class PkiProfileConfigMode( PkiProfileMode, CliSave.Mode ):
   def __init__( self, param ):
      PkiProfileMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

SecurityConfigMode.addChildMode( PkiProfileConfigMode,
                                 after=[ 'Mgmt.security' ] )
PkiProfileConfigMode.addCommandSequence( 'Mgmt.security.pki.profile' )

@CliSave.saver( 'Mgmt::Security::Ssl::Config', 'mgmt/security/ssl/config' )
def savePkiProfileConfig( entity, root, sysdbRoot, options ):
   for profileName, profileConfig in entity.profileConfig.iteritems():
      if profileConfig.profileType != "profileTypePki":
         continue
      secMode = root[ SecurityConfigMode ].getOrCreateModeInstance( 'security' )
      mode = secMode[ PkiProfileConfigMode ].getOrCreateModeInstance( profileName )
      cmds = mode[ 'Mgmt.security.pki.profile' ]

      if profileConfig.certKeyPair.certFile != "":
         cmds.addCommand( 'certificate %s key %s' %
                          ( profileConfig.certKeyPair.certFile, 
                            profileConfig.certKeyPair.keyFile ) )

      for certName in profileConfig.trustedCert:
         cmds.addCommand( 'trust certificate %s' % ( certName ) )

      for certName in profileConfig.chainedCert:
         cmds.addCommand( 'chain certificate %s' % ( certName ) )

      for crlName in profileConfig.crl:
         cmds.addCommand( 'crl %s' % ( crlName ) )

      if profileConfig.verifyExtendedParameters:
         cmds.addCommand( 'certificate requirement extended-key-usage' )
      elif options.saveAll:
         cmds.addCommand( 'no certificate requirement extended-key-usage' )

      if profileConfig.verifyHostnameMatch:
         cmds.addCommand( 'certificate requirement hostname match' )
      elif options.saveAll:
         cmds.addCommand( 'no certificate requirement hostname match' )

      if profileConfig.verifyBasicConstraintTrust:
         cmds.addCommand( 'trust certificate requirement '
                          'basic-constraint ca true' )
      elif options.saveAll:
         cmds.addCommand( 'no trust certificate requirement '
                          'basic-constraint ca true' )

      if profileConfig.verifyBasicConstraintChain:
         cmds.addCommand( 'chain certificate requirement '
                          'basic-constraint ca true' )
      elif options.saveAll:
         cmds.addCommand( 'no chain certificate requirement '
                          'basic-constraint ca true' )
      if profileConfig.verifyChainHasRootCA:
         cmds.addCommand( "chain certificate requirement include root-ca" )
      elif options.saveAll:
         cmds.addCommand( "no chain certificate requirement include root-ca" )

      if not profileConfig.verifyExpiryDateEndCert:
         cmds.addCommand( 'certificate policy expiry-date ignore' )
      elif options.saveAll:
         cmds.addCommand( 'no certificate policy expiry-date ignore' )

