# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Pcs import PcsServiceMode
from CliSavePlugin.Controllerdb import ( CvxConfigMode, controllerConfigPath,
                                        getClusterName )
import Toggles.ControllerAclToggleLib
# pylint: disable-msg=W0223
class PcsServiceConfigSaveMode( PcsServiceMode, CliSave.Mode ):
   def __init__( self, param ):
      PcsServiceMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CvxConfigMode.addChildMode( PcsServiceConfigSaveMode, after=[ 'cvx' ] )
PcsServiceConfigSaveMode.addCommandSequence( "PcsService.config" )
CliSave.GlobalConfigMode.addCommandSequence( "PcsServiceGlobal.config" )

@CliSave.saver( "Pcs::Config", "pcs/config",
                requireMounts=( controllerConfigPath, ) )
def savePcsServiceConfig( entity, root, sysdbRoot, options, requireMounts ):
   if not Toggles.ControllerAclToggleLib.toggleControllerAclEnabled():
      return
   cmds = []

   if entity.enabled or options.saveAll:
      cmds.append( "%sshutdown" % ( "no " if entity.enabled else "" ) )
   if entity.controllerIp != '0.0.0.0' or options.saveAll:
      cmd = "controller %s" % entity.controllerIp
      if entity.port != entity.defaultPort or options.saveAll:
         cmd += " %d" % entity.port
      cmds.append( cmd )

   if entity.username:
      cmds.append( "username %s" % entity.username )
   if entity.password:
      cmds.append( "password 7 %s" % CliSave.sanitizedOutput( options,
                                                              entity.password ) )
   if entity.endpointName:
      cmds.append( "enforcement-point %s" % entity.endpointName )
   if entity.thumbprint:
      cmds.append( "pinned-public-key %s" % entity.thumbprint )
   if entity.notificationUuid:
      cmds.append( "notification-id %s" % entity.notificationUuid )

   if cmds:
      cvxClusterName = getClusterName( requireMounts[ controllerConfigPath ] )
      mode = root[ CvxConfigMode ].getOrCreateModeInstance(
               CvxConfigMode.modeName( cvxClusterName ) )
      pcsServiceMode = mode[ PcsServiceConfigSaveMode ]
      pcsServiceMode = pcsServiceMode.getOrCreateModeInstance( "cvx-pcs" )
      pcsServiceMode = pcsServiceMode[ "PcsService.config" ]
      for cmd in cmds:
         pcsServiceMode.addCommand( cmd )
