# Copyright (c) 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Arnet
import CliSave
import IpUtils
from IntfCliSave import IntfConfigMode
from RoutingIntfUtils import allRoutingProtocolIntfNames

IntfConfigMode.addCommandSequence( 'Ira.dhcpIntf', after=[ 'Ira.ipIntf' ] )
CliSave.GlobalConfigMode.addCommandSequence( 'Ira.dhcp', before=[ IntfConfigMode ] )

@CliSave.saver( 'Ip::Dhcp::Relay::Config', 'ip/dhcp/relay/config',
                requireMounts = ( 'interface/config/all', 'interface/status/all' ) )
def saveDhcpRelayGlobal( entity, root, sysdbRoot, options,
                         requireMounts ):
   # do nothing unless forwarder is configured
   dhcpFwdConfig = entity
   if not( dhcpFwdConfig.serverIp or dhcpFwdConfig.serverIntf or
           dhcpFwdConfig.logVerbose or dhcpFwdConfig.intfConfig ):
      return
   for i in sorted( entity.serverIp, cmp=IpUtils.compareIpAddress ):
      root[ 'Ira.dhcp' ].addCommand( 'ip dhcp relay server %s' % i )
   for i in Arnet.sortIntf( entity.serverIntf ):
      root[ 'Ira.dhcp' ].addCommand( 'ip dhcp relay server %s' % i )
   if entity.logVerbose:
      root[ 'Ira.dhcp' ].addCommand( 'ip dhcp relay log verbose' )
   elif options.saveAll:
      root[ 'Ira.dhcp' ].addCommand( 'no ip dhcp relay log verbose' )

   # Interface config
   if options.saveAllDetail:
      cfgIntfNames = allRoutingProtocolIntfNames( sysdbRoot, includeEligible=True,
                                                  requireMounts=requireMounts )
   elif options.saveAll:
      # We allow IP configuration on switchport interfaces as well. Therefore, intfs
      # for config are all IP intfs and switchports with non-default config. 
      cfgIntfNames = set(
            allRoutingProtocolIntfNames( sysdbRoot, requireMounts=requireMounts ) +
            entity.intfConfig.keys() )
   else:
      cfgIntfNames = entity.intfConfig

   for intfName in cfgIntfNames:
      intfConfig = entity.intfConfig.get( intfName )
      if not intfConfig:
         if options.saveAll:
            intfConfig = Tac.newInstance( 'Ip::Dhcp::Relay::IntfConfig', intfName )
         else:
            continue
      saveDhcpRelayIntf( intfConfig, root, sysdbRoot, options )

def saveDhcpRelayIntf( entity, root, sysdbRoot, options ):
   # Don't try to save if they're all default.
   saveAll = options.saveAll
   if entity.clientAllowed or entity.serverAllowed or entity.circuitId != "" \
      or saveAll:
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( entity.name )
   else:
      return
   cmds = mode[ 'Ira.dhcpIntf' ]

   if entity.clientAllowed or entity.serverAllowed:
      cmds.addCommand( "ip dhcp relay%s%s" % (
                        " client" if entity.clientAllowed else "",
                        " server" if entity.serverAllowed else "" ) )
   elif saveAll:
      cmds.addCommand( "no ip dhcp relay client server" )
   if entity.circuitId != "":
      cmds.addCommand( "ip dhcp relay circuit-id %s" % entity.circuitId )
   elif saveAll:
      cmds.addCommand( "no ip dhcp relay circuit-id" )
