#!/usr/bin/python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave

CliSave.GlobalConfigMode.addCommandSequence( "Ejector.config" )

@CliSave.saver( 'Hardware::ModularSystem::EjectorCliConfig',
                'hardware/modularSystem/config/ejector' )
def saveHwModularSystemCliConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'Ejector.config' ]

   if not entity.powerOff:
      cmds.addCommand( 'hardware fabric ejector-handle open action log' )
