# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave
from IntfCliSave import IntfConfigMode
from IpLibConsts import DEFAULT_VRF

def _sortDefFirst( srcIntf1, srcIntf2 ):
   if srcIntf1.vrf == DEFAULT_VRF and srcIntf2.vrf != DEFAULT_VRF:
      return -1
   elif srcIntf1.vrf != DEFAULT_VRF and srcIntf2.vrf == DEFAULT_VRF:
      return 1
   return cmp( srcIntf1.vrf, srcIntf2.vrf )

CliSave.GlobalConfigMode.addCommandSequence( 'NetworkUrl.srcIntf', 
                                             after=[ IntfConfigMode ] )
@CliSave.saver( 'Mgmt::NetworkUrl::Config', 'mgmt/networkUrl/config' )
def saveNetworkUrlSrcIntfGlobal( networkUrlConfig, root, sysdbRoot, options ): 
   networkUrlProtocols = Tac.Type( "Mgmt::NetworkUrl::Protocol" )
   cmdRoot = root[ 'NetworkUrl.srcIntf' ]
   for proto in sorted( networkUrlProtocols.attributes ):
      if proto in networkUrlConfig.protocolConfig:
         protConf = networkUrlConfig.protocolConfig[ proto ]
         # iterate through source interfaces
         for srcIntf in sorted( protConf.srcIntf.itervalues(), cmp=_sortDefFirst ):
            if srcIntf.usedSourceInterface:
               token = 'source-interface'
            else:
               token = 'local-interface'
            template = 'ip %%s client %s %%s%%s' % token
            vrfToken = ' vrf %s' % srcIntf.vrf if srcIntf.saveWithVrfArg else ''
            cmdRoot.addCommand( template % ( proto, srcIntf.intfName, vrfToken ) )
      elif options.saveAll:
         if proto == 'http':
            srcIntfCmd = 'local-interface'
         else:
            srcIntfCmd = 'source-interface'
         cmdRoot.addCommand( 'no ip %s client %s' % ( proto, srcIntfCmd ) )
