# Copyright (c) 2007, 2008, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliSave
from IpLibConsts import DEFAULT_VRF

networkConfigCmdSeq = 'Network.config'
CliSave.GlobalConfigMode.addCommandSequence( networkConfigCmdSeq )

@CliSave.saver( 'System::NetConfig', 'sys/net/config' )
def saveHostname( netConfig, root, sysdbRoot, options ):

   saveAll = options.saveAll
   vrfString = ''
   if netConfig.vrfName:
      vrfString = 'vrf %s ' % netConfig.vrfName

   cmds = root[ 'Network.config' ]
   if netConfig.hostname:
      cmds.addCommand( "hostname %s" % netConfig.hostname )
   elif saveAll:
      cmds.addCommand( "no hostname" )

   if len( netConfig.sourceIntf ) != 0:
      for ( vrfName, srcIntf ) in netConfig.sourceIntf.items():
         siVrf = ''
         if vrfName != DEFAULT_VRF:
            siVrf = 'vrf %s ' % vrfName
         cmds.addCommand( 'ip domain lookup %ssource-interface %s' %
                          ( siVrf, srcIntf ) )
   elif saveAll:
      cmds.addCommand( "no ip domain lookup source-interface" )

   for v4NameServer in sorted( netConfig.nameServer.values() ):
      cmds.addCommand( "ip name-server %s%s" % ( vrfString, v4NameServer ) )
   for v6NameServer in sorted( netConfig.v6NameServer.values() ):
      cmds.addCommand( "ip name-server %s%s" % ( vrfString,
                                                 v6NameServer.stringValue ) )

   if saveAll and ( len( netConfig.nameServer ) == 0 ) and (
      len( netConfig.v6NameServer ) == 0 ):
      # no name server configured
      cmds.addCommand( "no ip name-server" )

   if netConfig.dscpValue:
      cmds.addCommand( "dns qos dscp %d" % netConfig.dscpValue )
   elif saveAll:
      cmds.addCommand( "no dns qos dscp" )

   cmd = 'dns domain'
   if netConfig.domainName:
      cmds.addCommand( "%s %s" % ( cmd, netConfig.domainName ) )
   elif saveAll:
      cmds.addCommand( "no %s" % cmd )

   for domain in netConfig.domainList.itervalues():
      cmds.addCommand( "ip domain-list %s" % domain )
   for hostname, hostEntry in sorted( netConfig.hostAddr.items() ):
      addressString = " ".join(
         [ ipAddress for ipAddress in sorted( hostEntry.ipAddr.keys() ) ] )
      if not addressString == "":
         cmds.addCommand( "ip host %s %s" % ( hostname, addressString ) )
      addressString = " ".join(
         [ ip6Address.stringValue
           for ip6Address in sorted( hostEntry.ip6Addr.keys() ) ] )
      if not addressString == "":
         cmds.addCommand( "ipv6 host %s %s" % ( hostname, addressString ) )
   if saveAll and ( len( netConfig.hostAddr ) == 0 ):
      # no mapping exists
      cmds.addCommand( "no ip host" )
      cmds.addCommand( "no ipv6 host" )

   if netConfig.externalDnsProxy:
      cmds.addCommand( 'ip domain proxy' )
   elif saveAll:
      cmds.addCommand( 'no ip domain proxy' )
