# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave, IntfCliSave, EthIntfUtil

IntfCliSave.IntfConfigMode.addCommandSequence( 'Mvrp.config' )

@CliSave.saver( 'Mvrp::Config', 'mvrp/config',
                requireMounts = ( 'interface/config/eth/phy/all', ) )
def saveConfig( entity, root, sysdbRoot, options,
                requireMounts ):
   saveAll = options.saveAll

   if saveAll:
      phyIntfConfig = requireMounts[ 'interface/config/eth/phy/all' ]
      phyIntfNames = EthIntfUtil.allPhyEthernetInterfaceNames( phyIntfConfig )
      cfgIntfNames = set( phyIntfNames + entity.intfEnable.keys() )
   else:
      cfgIntfNames = entity.intfEnable
                          
   for intfName in cfgIntfNames:
      intfMode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance(
         intfName )
      cmds = intfMode[ 'Mvrp.config' ]

      intfEnable = entity.intfEnable.get( intfName )
      if intfEnable:
         cmds.addCommand( 'mvrp ' )
      elif saveAll:
         cmds.addCommand( 'no mvrp' )
