# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from CliMode.Mss import MssMode
import CliSave
from CliSavePlugin.Controllerdb import ( CvxConfigMode,
                                         controllerConfigPath,
                                         getClusterName )
import Tac
import Toggles.MssToggleLib as MssToggleLib

defaults = Tac.Value( 'Mss::CliDefaults' )

#------------------------------------------------------------------------------
# Mss Mode Saver
#------------------------------------------------------------------------------

class MssConfigSaveMode( MssMode, CliSave.Mode ):
   def __init__( self, param ):
      MssMode.__init__( self )
      CliSave.Mode.__init__( self, param )

CvxConfigMode.addChildMode( MssConfigSaveMode,
                            after=[ 'cvx' ] )

MssConfigSaveMode.addCommandSequence( 'mss.config' )

#------------------------------------------------------------------------------
# Entity Saver
#------------------------------------------------------------------------------

@CliSave.saver( 'Mss::Config', 'mss/config',
                requireMounts=( controllerConfigPath, ) )
def saveMssConfig( entity, root, sysdbRoot, options, requireMounts ):
   cmds = []

   if entity.enable:
      cmds.append( 'no shutdown' )
   elif options.saveAll:
      cmds.append( 'shutdown' )

   if options.saveAll or entity.policyEnforceRule != defaults.policyEnforceRule:
      rules = []
      if entity.policyEnforceRule.group:
         rules.append( 'group' )
      if entity.policyEnforceRule.verbatim:
         rules.append( 'verbatim' )
      cmds.append( 'policy enforcement rules %s' % ' '.join( rules ) )

   PolicyEnforcementConsistency = Tac.Type( 'Mss::PolicyEnforcementConsistency' )
   if MssToggleLib.toggleMssL3V2Enabled() and \
      ( options.saveAll or \
      entity.policyEnforcementConsistency != defaults.policyEnforcementConsistency ):
      if entity.policyEnforcementConsistency == PolicyEnforcementConsistency.strict:
         cmds.append( 'policy enforcement consistency strict' )
      else:
         cmds.append( 'policy enforcement consistency best-effort' )

   if MssToggleLib.toggleMssVxlanTrafficInspectEnabled():
      if entity.vxlanTrafficInspect:
         vteps = ' '.join( [ ip.stringValue for ip in
                             sorted( entity.vxlanTrafficInspect.iterkeys(),
                                     key=lambda x: x.sortKey ) ] )
         cmds.append( 'vxlan traffic inspect ' + vteps )
      elif options.saveAll:
         cmds.append( 'no vxlan traffic inspect' )

   if cmds:
      clusterName = getClusterName( requireMounts[ controllerConfigPath ] )
      cvxMode = root[ CvxConfigMode ].getOrCreateModeInstance(
         CvxConfigMode.modeName( clusterName ) )
      mssMode = cvxMode[ MssConfigSaveMode ].getOrCreateModeInstance( 'cvx-mss' )
      cmdSeq = mssMode[ 'mss.config' ]

      for cmd in cmds:
         cmdSeq.addCommand( cmd )
