# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode.Msrp
import Tac
import CliSave, IntfCliSave, EthIntfUtil
from Url import filenameToUrl

mrpConstants = Tac.Type( 'Mrp::MrpTimerConstants' )
msrpConstants = Tac.Type( 'Msrp::MsrpShapingMultiplierConstants' )

IntfCliSave.IntfConfigMode.addCommandSequence( 'Msrp.config' )

@CliSave.saver( 'Msrp::Config', 'msrp/config',
                requireMounts = ( 'interface/config/eth/phy/all',
                                  'interface/config/all', 'interface/status/all' ) )
def saveConfig( entity, root, sysdbRoot, options,
                requireMounts ):
   saveAll = options.saveAll

   if saveAll:
      phyIntfConfig = requireMounts[ 'interface/config/eth/phy/all' ]
      phyIntfNames = EthIntfUtil.allPhyEthernetInterfaceNames( phyIntfConfig )
      cfgIntfNames = set( phyIntfNames + entity.intfEnable.keys() )
   else:
      cfgIntfNames = entity.intfEnable
                          
   for intfName in cfgIntfNames:
      intfMode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance(
         intfName )
      cmds = intfMode[ 'Msrp.config' ]

      intfEnable = entity.intfEnable.get( intfName )
      if intfEnable:
         cmds.addCommand( 'msrp ' )
      elif saveAll:
         cmds.addCommand( 'no msrp' )

class MsrpConfigMode( CliMode.Msrp.MsrpConfigMode, CliSave.Mode ):

   def __init__( self, param ):
      CliMode.Msrp.MsrpConfigMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( MsrpConfigMode )
MsrpConfigMode.addCommandSequence( 'Msrp.cliConfig' )

@CliSave.saver( 'Msrp::CliConfig', 'msrp/cliConfig' )
def saveMsrpConfig( entity, root, sysdbRoot, options ):
   cmds = []
   saveAll = options.saveAll
   macToDeviceConfFileName = entity.macToDeviceNameMapFile
   if macToDeviceConfFileName:
      cmds.append( 'streams load-file %s' % filenameToUrl( 
            macToDeviceConfFileName ) )
   elif saveAll:
      cmds.append( 'no streams load-file' )

   if entity.disableShaping:
      cmds.append( 'no shaping' )
   elif entity.shapingMultiplier != msrpConstants.defaultMultiplier:
      cmds.append( 'shaping multiplier %s' % entity.shapingMultiplier )
   elif saveAll:
      cmds.append( 'default shaping multiplier' )

   if cmds:
      mode = root[ MsrpConfigMode ].getOrCreateModeInstance( "msrp" )
      cmdSeq = mode[ 'Msrp.cliConfig' ]
      for cmd in cmds:
         cmdSeq.addCommand( cmd )

IntfCliSave.IntfConfigMode.addCommandSequence( 'Mrp.mrpConfig' )      

@CliSave.saver( 'Mrp::MrpConfig', 'mrp/config',
                requireMounts = ( 'interface/config/eth/phy',
                                  'interface/config/all', 'interface/status/all' ) )
def saveMrpTimerConfig( entity, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll
   leaveIntfNames = entity.intfLeaveTime.keys()
   leaveAllIntfNames = entity.intfLeaveAllTime.keys()
   phyIntfConfig = requireMounts[ 'interface/config/eth/phy' ]
   phyIntfNames = EthIntfUtil.allPhyEthernetInterfaceNames( phyIntfConfig )
   
   for intf in set( leaveIntfNames + phyIntfNames ):
      intfMode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance(
         intf )
      cmds = intfMode[ 'Mrp.mrpConfig' ]
      if intf in leaveIntfNames:
         if entity.intfLeaveTime[ intf ] != mrpConstants.defaultLeaveTime:
            cmds.addCommand( 'mrp leave-timer %s' % entity.intfLeaveTime[ intf ] )
         elif saveAll:
            cmds.addCommand( 'default mrp leave-timer' )
      elif saveAll:
         cmds.addCommand( 'default mrp leave-timer' )

   for intf in set( leaveAllIntfNames + phyIntfNames ):
      intfMode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance(
         intf )
      cmds = intfMode[ 'Mrp.mrpConfig' ]
      if intf in leaveAllIntfNames:
         if entity.intfLeaveAllTime[ intf ] != mrpConstants.defaultLeaveAllTime:
            cmds.addCommand( 'mrp leave-all-timer %s' % 
                             entity.intfLeaveAllTime[ intf ] )
         elif saveAll:
            cmds.addCommand( 'default mrp leave-all-timer' )
      elif saveAll:
         cmds.addCommand( 'default mrp leave-all-timer' )
