# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.MplsUtilsMode import MplsUtilsMode
from TypeFuture import TacLazyType

MplsOamStandard = TacLazyType( 'MplsUtils::MplsOamStandard' )

#-------------------------------------------------------------------------------
# Object used for saving commands in "mpls-ping" mode.
#-------------------------------------------------------------------------------
class MplsUtilsModeConfigMode( MplsUtilsMode, CliSave.Mode ):
   def __init__( self, param ):
      MplsUtilsMode.__init__( self )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( MplsUtilsModeConfigMode,
                                       after=[ 'Mpls.config' ] )
CliSave.GlobalConfigMode.addCommandSequence( 'Mpls.MplsUtilsConfig',
                                             after=[ 'Mpls.config' ] )

MplsUtilsModeConfigMode.addCommandSequence( 'Mpls.MplsUtils' )

def saveLspPingServiceAcls( config, root, sysdbRoot, options, requireMounts ):

   aclCpConfig = requireMounts[ 'acl/cpconfig/cli' ]
   for aclType in [ 'ip', 'ipv6' ]:
      serviceAclVrfConfig = aclCpConfig.cpConfig[ aclType ].serviceAcl
      for vrf, serviceAclConfig in sorted( serviceAclVrfConfig.items() ):
         if ( 'lspPing' in serviceAclConfig.service and
              serviceAclConfig.service[ 'lspPing' ].aclName ):
            mode = root[
                     MplsUtilsModeConfigMode ].getOrCreateModeInstance( 'default' )
            mode[ 'Mpls.MplsUtils' ].addCommand( '%s access-group %s vrf %s '
                  % ( aclType, serviceAclConfig.service[ 'lspPing' ].aclName, vrf ) )

def saveIcmpTunnel( config, root, options, requireMounts ):
   cmd = '{no}mpls icmp {token} tunneling'

   tokens = []
   tokens.append( ( 'ttl-exceeded', 'icmpTtlTunneling' ) )

   mplsHwCapability = requireMounts[ 'routing/hardware/mpls/capability' ]
   if mplsHwCapability.mplsFragNeededIcmpTunnelingSupported:
      tokens.append( ( 'fragmentation-needed', 'fragNeededTunneling' ) )

   for token, configAttr in sorted( tokens ):
      if getattr( config, configAttr ):
         addCmd = cmd.format( no='', token=token )
      elif options.saveAll:
         addCmd = cmd.format( no='no ', token=token )
      else:
         addCmd = None
      if addCmd:
         root[ 'Mpls.MplsUtilsConfig' ].addCommand( addCmd )

def saveMplsOamStandard( config, root, options, requireMounts ):
   baseCmd = 'mpls oam standard {standard}'
   if config.oamStandard == MplsOamStandard.ietf:
      cmd = baseCmd.format( standard=MplsOamStandard.ietf )
      root[ 'Mpls.MplsUtilsConfig' ].addCommand( cmd )
   elif options.saveAll:
      cmd = baseCmd.format( standard=MplsOamStandard.arista )
      root[ 'Mpls.MplsUtilsConfig' ].addCommand( cmd )

@CliSave.saver( 'MplsUtils::Config', 'mplsutils/config',
                requireMounts=( 'routing/hardware/mpls/capability',
                                'acl/cpconfig/cli' ) )
def saveMplsUtilsConfig( config, root, sysdbRoot, options, requireMounts ):
   saveLspPingServiceAcls( config, root, sysdbRoot, options, requireMounts )
   saveIcmpTunnel( config, root, options, requireMounts )
   saveMplsOamStandard( config, root, options, requireMounts )
