# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac
from EbraCliSave import labelEntryHook
from MplsLib import tunTypeEnumDict

FecId = Tac.Type( 'Smash::Fib::FecId' )

CliSave.GlobalConfigMode.addCommandSequence( 'Mpls.debug', after=[ 'Mpls.routes' ] )

@CliSave.saver( 'Mpls::LfibSysdbStatus', 'mpls/debug/lfib' )
def saveDebugLfib( entity, root, sysdbRoot, options, requireMounts ):
   debugIpLookupViaCmd = 'mpls debug ip-lookup-via '
   debugVlanViaCmd = 'mpls debug vlan-via '
   debugVlanFloodViaCmd = 'mpls debug vlan-flood-via '
   debugESFilterViaCmd = 'mpls debug es-filter-via '
   debugExtFecViaCmd = 'mpls static top-label '

   for label, via in entity.ipLookupVia.items():
      cmd = debugIpLookupViaCmd + str( label )
      cmd += ' ' + via.vrfName
      cmd += ' ' + via.payloadType

      root[ 'Mpls.debug' ].addCommand( cmd )

   for label, via in entity.vlanVia.items():
      flag = 'true' if via.flag else 'false'

      cmd = debugVlanViaCmd + str( label )
      cmd += ' ' + str( via.vlanId )
      cmd += ' control-word-present ' + flag

      root[ 'Mpls.debug' ].addCommand( cmd )

   for label, via in entity.vlanFloodVia.items():
      flag = 'true' if via.flag else 'false'

      cmd = debugVlanFloodViaCmd + str( label )
      cmd += ' ' + str( via.vlanId )
      cmd += ' control-word-present ' + flag

      root[ 'Mpls.debug' ].addCommand( cmd )

   for label, via in entity.ethernetSegmentFilterVia.items():
      cmd = debugESFilterViaCmd + str( label )
      cmd += ' ' + str( via.intfId )

      root[ 'Mpls.debug' ].addCommand( cmd )

   for label, via in entity.extFecVia.items():
      cmd = debugExtFecViaCmd + str( label ) + ' debug'
      fecId = FecId( via.fecId )
      cmd += ' fec-type ' + fecId.adjType().lower().replace( 'adj', '' )
      cmd += ' fec-index ' + str( fecId.adjIndex() )
      cmd += ' ' + via.labelAction
      if via.payloadType != 'autoDecide':
         cmd += ' payload-type ' + via.payloadType

      root[ 'Mpls.debug' ].addCommand( cmd )

# Add a hook to return the command for label entry unicast mac addresses of
# bridging config
def labelEntryExtension( macAddr, vlanId, label, intfId ):
   tunnelIdVal = Tac.Type( 'Arnet::DynamicTunnelIntfId' ).tunnelId( intfId )
   tunnelId = Tac.Value( 'Tunnel::TunnelTable::TunnelId', tunnelIdVal )
   tunTypeEnum = tunnelId.tunnelType()
   tunType = tunTypeEnumDict[ tunTypeEnum ]
   tunInd = tunnelId.tunnelIndex()
   cmd = 'mac address-table debug static %s vlan %s label %d tunnel %s %d' \
         % ( macAddr, vlanId, label, tunType, tunInd )
   return cmd

labelEntryHook.addExtension( labelEntryExtension )
