# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliSave
import CliMode.MosApiMode as MosApiMode
import MosApp
from TypeFuture import TacLazyType

AGENT_TYPE = TacLazyType( 'GenericAgent::AgentTypeEnum' )

class MosApiAppConfigMode( MosApiMode.MosApiAppMode, CliSave.Mode ):
   def __init__( self, param ):
      MosApiMode.MosApiAppMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def enterCmd( self ):
      return 'application %s' % self.param_

CliSave.GlobalConfigMode.addChildMode( MosApiAppConfigMode )
MosApiAppConfigMode.addCommandSequence( 'MosApi.config' )

@CliSave.saver( 'Tac::Dir', 'daemon/agent/config' )
def saveMosApiAppConfig( entity, root, sysdbRoot, options ):
   for appName, appConfig in entity.iteritems():
      if appConfig.agentType != AGENT_TYPE.mosApiShim:
         continue

      if appName not in MosApp.MOSAPI_INSTANCE.apps:
         # this means that it is a daemon
         continue

      if not appConfig.option and not appConfig.enabled:
         # if the mode is empty don't add any commands
         return

      mode = root[ MosApiAppConfigMode ].getOrCreateModeInstance( appName )
      cmds = mode[ 'MosApi.config' ]
      for k, v in appConfig.option.iteritems():
         cmd = '%s %s' % ( k, v )
         cmds.addCommand( cmd.strip() )

      if appConfig.enabled:
         cmds.addCommand( 'no shutdown' )
