# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave
import Tracing

__defaultTraceHandle__ = Tracing.Handle( 'ModCliSave')
t0 = Tracing.trace0

CliSave.GlobalConfigMode.addCommandSequence( 'Module.config' )

def _getSlots( requireMounts ):
   entityMibRoot = requireMounts[ "hardware/entmib" ]
   if entityMibRoot.chassis and entityMibRoot.chassis.initStatus == "ok":
      return entityMibRoot.root.cardSlot.values()
   return []


def slotName( slot ):
   return '%s%s' % ( slot.tag, slot.label )

@CliSave.saver( 'Power::SoftwareFuse','power/fuse/config/admin',
                requireMounts = ( 'hardware/entmib', ) )
def saveModuleCli( entity, root, sysdbRoot, options,
                   requireMounts ):
   cmds = root[ 'Module.config' ]
   poweredOff =  entity.powerOffRequested.keys() 
   if options.saveAll:
      slots = _getSlots( requireMounts )
      slotList = sorted(  [ slotName( slot ) for slot in slots ] )
   else:
      slotList = sorted( poweredOff )

   for slot in slotList:
      t0( "iterating over slot ", slot )
      if slot in poweredOff:
         cmds.addCommand( "no power enable module %s" %slot)
      else:
         cmds.addCommand( "power enable module %s" %slot)
